//=============================================================================
//
//  MotorRun.c :
//
//  Example for running a motor on M1 with simple C-Code 
//
//-----------------------------------------------------------------------------
// Disclaimer - Exclusion of Liability
//
// This software is distributed in the hope that it will be useful,but WITHOUT 
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. It can be used an modified by anyone
// free of any license obligations or authoring rights.
//=============================================================================

#include "StdAfx.h"

enum MotorIdx {MOTOR_1 = 0, MOTOR_2, MOTOR_3, MOTOR_4};

#define MOTOR_ON    TRUE
#define MOTOR_OFF   FALSE

#define STRMAXLEN   80

HANDLE  fthdl;
DWORD   errCode;
char    ComPortName[STRMAXLEN];
char    LibVersion[STRMAXLEN];


//=============================================================================

/*-----------------------------------------------------------------------------
 *  MotorRun  
 *---------------------------------------------------------------------------*/
static void MotorRun(void) {

    int duty;

    //  set Motor output ON
    SetFtMotorConfig(fthdl, TA_LOCAL, MOTOR_1, MOTOR_ON);

    duty = 0;
    do {
        duty += 128;

        printf("Motor run with duty= %d\n", duty);

        //  set motor values
        SetOutMotorValues(fthdl, TA_LOCAL, MOTOR_1, duty, 0);

        Sleep(1000);        
    } while (duty < DUTY_MAX);

    //  stop motor
    SetOutMotorValues(fthdl, TA_LOCAL, MOTOR_1, 0, 0);

    Sleep(2000);

    duty = DUTY_MAX;
    do {
        //  set motor values
        SetOutMotorValues(fthdl, TA_LOCAL, MOTOR_1, 0, duty);

        printf("Motor run with duty= %d\n", duty);

        Sleep(1000);

        duty -= 128;
    } while ( duty > 0);

    //  stop motor
    SetOutMotorValues(fthdl, TA_LOCAL, MOTOR_1, 0, 0);
}

/*-----------------------------------------------------------------------------
 *  CheckParameter  
 *---------------------------------------------------------------------------*/
static int CheckCOMPar(int argc, char *argv[]) {

    char    *pStr;
    int     comNo;

    if (argc >= 2) {
        if (strlen(argv[1]) > 3) {
            if ((pStr=strstr(argv[1],"COM")) != NULL) {
                sscanf(pStr+3, "%d", &comNo);
                if (comNo >= 1 && comNo <= 255)
                    return 0;
                else {
                    printf("MotorRun.exe: invalid COM number...\n\n");
                    return 1;
                }
            }
        }
    }

    printf("MotorRun.exe: no input given...\n\n");
    return 1;
}

/*-----------------------------------------------------------------------------
 *  main
 *  
 *---------------------------------------------------------------------------*/
int main(int argc, char *argv[]) {

    printf("\nExample MotorRun ...\n");

    //  check input paramter
    if (CheckCOMPar(argc,argv)) {
        printf("Usage: MotorRun.exe COMxx\t(e.g. COM2 or COM32)\n");
        return 1;
    }

    //  get library version
    ftxGetLibVersionStr(LibVersion, STRMAXLEN);
    printf("\nftMscLib %s\n", LibVersion);

    //  library initialization
    errCode = ftxInitLib();

    strcpy(ComPortName, argv[1]);
    printf("\n\nOpen ComPort '%s' ...\n", ComPortName);

    //  open COM port
    fthdl = ftxOpenComDevice(ComPortName, 38400, &errCode);

    if (errCode == FTLIB_ERR_SUCCESS) {

        printf("Connected to ROBO TX Controller ...\n");

        //  starting Transfer Area
        errCode = ftxStartTransferArea(fthdl);

        if (errCode == FTLIB_ERR_SUCCESS) {

            printf("Transfer Area was started and runs...\n");

            MotorRun();

            //  stop Transfer Area
            ftxStopTransferArea(fthdl);
        }

        else {
            //  error case
            printf("Error: Transfer Area was not started !\n");
        }

        //  closing port
        printf("Closing ComPort '%s' ...\n", ComPortName);
        errCode = ftxCloseDevice(fthdl);
    }

    else {
        //  error case
        printf("Error: No interface available (Port '%s')\n", ComPortName);
    }

    //  close library
    ftxCloseLib();

    return 0;
}
